<?php
// Enqueue parent and child theme styles
add_action('wp_enqueue_scripts', 'astra_child_enqueue_styles');
function astra_child_enqueue_styles() {
    wp_enqueue_style('astra-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('astra-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('astra-style')
    );
}

// Redirect to checkout after add to cart
add_filter('woocommerce_add_to_cart_redirect', 'redirect_to_checkout_after_add');
function redirect_to_checkout_after_add() {
    return wc_get_checkout_url();
}


add_filter('woocommerce_checkout_fields', 'custom_remove_checkout_fields');

function custom_remove_checkout_fields($fields) {
    // Remove City
   // unset($fields['billing']['billing_city']);
    
    // Remove State
    unset($fields['billing']['billing_state']);
    
    // Remove Postcode / ZIP
    unset($fields['billing']['billing_postcode']);

    return $fields;
}

add_action('template_redirect', function() {
  if (is_product()) {
    global $post;
    
    if ($post->ID == 1466) {
      wp_redirect('/themes/', 301);
      exit;
    }
    elseif ($post->ID == 1650) {
      wp_redirect('/plugins/', 301);
      exit;
    }
	  
	  elseif ($post->ID == 1756) {
      wp_redirect('/all-access/', 301);
      exit;
    }
  }
});

// ALL Acces Page Login
// ----------------------------------------------
// ----------------------------------------------
function add_allaccess_user_role() {
    add_role('allaccess_member', 'All Access Member', [
        'read' => true,
        'level_0' => true,
    ]);
}
add_action('init', 'add_allaccess_user_role');


//Assign Role After Purchase (Auto) & send email

function assign_allaccess_role_and_create_credentials($order_id) {
    $order = wc_get_order($order_id);
    $product_name_target = 'All Access'; // CHANGE if needed

    foreach ($order->get_items() as $item) {
        if ($item->get_name() === $product_name_target) {
            $user_id = $order->get_user_id();
            $user = get_userdata($user_id);

            if (!$user) {
                return;
            }

            $customer_name = $order->get_billing_first_name();
            $order_id_part = substr($order_id, 0, 3);
            $name_part = ucfirst(substr(preg_replace("/[^A-Za-z]/", '', $customer_name), 0, 4));
            $special_chars = ['#', '@', '!', '$', '%', '*'];
            $random_char = $special_chars[array_rand($special_chars)];

            $new_password = $name_part . $order_id_part . $random_char;
            wp_set_password($new_password, $user_id);

            // Add role if not already added
            $wp_user = new WP_User($user_id);
            $wp_user->add_role('allaccess_member');

            // Send login details via email
            $email = $user->user_email;
            $subject = 'Your All Access Login Details';
            $message = "Hi $customer_name,\n\nThank you for your All Access purchase!\n\nHere are your login credentials:\n\nUsername: {$user->user_login}\nPassword: $new_password\n\nYou can now log in and access your downloads here:\n" . home_url('/download-hub') . "\n\nBest regards,\nVohra E-Mart";

            $headers = array('Bcc: vohraverse@gmail.com');
			wp_mail($email, $subject, $message, $headers);

        }
    }
}
add_action('woocommerce_order_status_completed', 'assign_allaccess_role_and_create_credentials');

//Check user role before loading the page
function restrict_all_access_page() {
    // Only apply on front-end
    if (is_admin()) return;

    if (is_page('download-hub')) {
        // If not logged in, redirect to login
        if (!is_user_logged_in()) {
            wp_redirect(wp_login_url(get_permalink()));
            exit;
        }

        // If logged in, check user role
        $user = wp_get_current_user();
        if (!in_array('allaccess_member', (array) $user->roles) && !in_array('administrator', (array) $user->roles)) {
            wp_redirect(home_url()); // Or redirect wherever you want
            exit;
        }
    }
}
add_action('template_redirect', 'restrict_all_access_page');

// Hide menu items based on user role
add_filter('wp_nav_menu_objects', 'custom_hide_menu_items_based_on_user', 10, 2);

function custom_hide_menu_items_based_on_user($items, $args) {
    // Check menu ID (adjust this to target specific menu locations if needed)
    if (!in_array($args->menu_id, ['ast-hf-menu-1', 'menu-primary'])) {
        return $items;
    }

    // Get current user info
    $user = wp_get_current_user();
    $is_logged_in = is_user_logged_in();
    $has_all_access = in_array('allaccess_member', (array) $user->roles);

    foreach ($items as $key => $item) {
        // Hide items for 'all access' role
        if ($has_all_access && in_array($item->ID, [1696, 1695, 1768])) {
            unset($items[$key]);
        }

        // Hide items for non-logged-in users
        if (!$is_logged_in && in_array($item->ID, [1767, 1769])) {
            unset($items[$key]);
        }
    }

    return $items;
}


// fetch logged in user details
function allaccess_welcome_box() {
    if ( is_user_logged_in() && ( current_user_can('allaccess_member') || current_user_can('administrator') ) ) {
        $current_user = wp_get_current_user();
        $name = ucfirst( $current_user->user_firstname );
        if ( empty($name) ) {
            $name = ucfirst( $current_user->display_name );
        }

        ob_start();
        ?>
        <div style="display:flex;justify-content:space-between;align-items:center;padding:15px;background:#f8f8f8;border-radius:8px;">
            <h2 style="margin:0;font-size:20px;">Welcome, <?php echo esc_html($name); ?></h2>
            <a href="<?php echo wp_logout_url(home_url()); ?>" style="background:#2962FF;color:#fff;padding:8px 16px;border-radius:6px;text-decoration:none;font-weight:500;">Logout</a>
        </div>
        <?php
        return ob_get_clean();
    } else {
        wp_redirect( wp_login_url() );
        exit;
    }
}
add_shortcode('allaccess_welcome', 'allaccess_welcome_box');




// link Chnage


add_filter('woocommerce_customer_get_downloadable_products', '__return_empty_array');

add_action('woocommerce_thankyou', 'vohraemart_add_secure_download_links', 0, 1);

function vohraemart_add_secure_download_links($order_id) {
    $order = wc_get_order($order_id);

	// Show only if order is completed
    if ($order->get_status() !== 'completed') {
        return;
    }
    echo '<h3>Your Downloads</h3><ul>';
    foreach ($order->get_items() as $item) {
        $product_id = $item->get_product_id();
        $product = wc_get_product($product_id);
        
        // Only apply for downloadable products
        if ($product->is_downloadable()) {
            $download_link = site_url("/private/download.php?order=$order_id&product=$product_id");
            echo "<li style='list-style: none;'><a class='button' href='$download_link' target='_blank'>Download: " . esc_html($product->get_name()) . "</a></li>";
        }
    }
    echo '</ul>';
}
