<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_key'])) {
    $productKey = $_POST['product_key'];

    function generate_token($length = 16) {
        return bin2hex(random_bytes($length));
    }

    function create_download_token($product_key) {
        $fileMap = json_decode(file_get_contents('file-map.json'), true);
        if (!isset($fileMap[$product_key])) {
            return false;
        }

        $file_id = $fileMap[$product_key];
        $token = generate_token();
        $downloads = json_decode(file_get_contents('downloads.json'), true);
        $downloads[$token] = [
            'file_id' => $file_id,
            // 'expires' => time() + 600 // Expires in 10 minutes
             'expires' => null
        ];
        file_put_contents('downloads.json', json_encode($downloads));
        return $token;
    }

    $token = create_download_token($productKey);
    if ($token) {
        $downloadUrl = "https://vohraemart.com/private/secure-download.php?token=" . $token;
        echo "<p><strong>Secure Download Link:</strong><br><a href='$downloadUrl'>$downloadUrl</a></p>";
    } else {
        echo "<p style='color:red;'>Invalid product key.</p>";
    }
}
?>

<form method="POST">
    <label for="product_key">Enter Product Key:</label><br>
    <input type="text" name="product_key" required>
    <button type="submit">Generate Secure Link</button>
</form>
