<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['links'])) {
    $links = explode(',', $_POST['links']);
    $output = [];
    $count = 1;

    foreach ($links as $link) {
        $link = trim($link);

        if (preg_match('/\/d\/(.*?)\//', $link, $matches)) {
            $file_id = $matches[1];
            $output["product" . $count] = $file_id;
            $count++;
        }
    }

    echo "<pre>" . json_encode($output, JSON_PRETTY_PRINT) . "</pre>";
}
?>

<form method="POST">
    <label for="links">Paste Google Drive Links (comma-separated):</label><br>
    <textarea name="links" rows="6" cols="100" required></textarea><br><br>
    <button type="submit">Extract IDs</button>
</form>
